library(phangorn)
library(rpanel)

pars = c(1,1,1,0,0,1,0,1,0,1,1,1,0,1,1,0)
a <- rbind(pars[1:4], pars[5:8], pars[9:12], pars[13:16])
a <- data.frame(a)
names(a) <- c("A","B","C","D")
a.1  <- as.phyDat(a, type="USER", levels=0:1)
a.t <- pratchet(a.1, trace=0)
a.tr <- root(a.t, outgroup="A", resolve.root=T)
plot(a.tr)

plot.phylogeny <- function(panel) {
   with(panel, {
      dev.set(dev.number)
      a <- rbind(pars[1:4],
        pars[5:8],
        pars[9:12],
        pars[13:16])
      a <- data.frame(a)
      names(a) <- c("A","B","C","D")
      a.1  <- as.phyDat(a, type="USER", levels=0:1)
      a.t <- pratchet(a.1, trace=0)
      a.tr <- root(a.t, outgroup="A", resolve.root=T)
      plot(a.tr)
      })
   panel
   }

rp.phylogeny <- function() {
   pname <- rp.control("Change the field and press ENTER",
      dev.number = dev.cur(),
      pars = c(1,1,1,0,0,1,0,1,0,1,1,1,0,1,1,0))
   rp.textentry(pname, pars, action = plot.phylogeny, title = "",
      labels = c("Taxon A, character 1 (0/1):",
      "Taxon B, character 1 (0/1):",
      "Taxon C, character 1 (0/1):",
      "Taxon D, character 1 (0/1):",
      "Taxon A, character 2 (0/1):",
      "Taxon B, character 2 (0/1):",
      "Taxon C, character 2 (0/1):",
      "Taxon D, character 2 (0/1):",
      "Taxon A, character 3 (0/1):",
      "Taxon B, character 3 (0/1):",
      "Taxon C, character 3 (0/1):",
      "Taxon D, character 3 (0/1):",
      "Taxon A, character 4 (0/1):",
      "Taxon B, character 4 (0/1):",
      "Taxon C, character 4 (0/1):",
      "Taxon D, character 4 (0/1):")
      )
   }

rp.phylogeny()
